#include <bits/stdc++.h>

#define int long long

#define pb push_back

const int N = 2e5 + 10;

using namespace std;

struct fenwick {
    vector<int>ft;
    void build(int n) {
        ft.resize(n + 10);
    }
    void update(int index,int n,int val) {
        while(index <= n) {
            ft[index] += val;
            index += index & -index;
        }
    }
    int get(int index) {
        int res = 0;
        while(index >= 1) {
            res += ft[index];
            index -= index & -index;
        }
        return res;
    }
};

signed main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n,q;
    cin >> n;
    vector<int>a(n + 1);
    fenwick fenw[60];
    for(int i = 0; i < 60; i++) fenw[i].build(n);
    for(int i = 1; i <= n; i++) {
        cin >> a[i];
        for(int j = 0; j < 60; j++) {
            if((1ll << j) & a[i]) fenw[j].update(i,n,1);
        }
    }
    cin >> q;
    while(q--) {
        int l,r;
        cin >> l >> r;
        if(l < 0) {
            for(int j = 0; j < 60; j++) {
                if((1ll << j) & a[-l]) fenw[j].update(-l,n,-1);
            }
            for(int j = 0; j < 60; j++) {
                if((1ll << j) & r) fenw[j].update(-l,n,1);
            }
            a[-l] = r;
            continue;
        }
        bool ok = true;
        for(int j = 0; j < 60; j++) {
            if(fenw[j].get(r) - fenw[j].get(l - 1) > 1) ok = false;
        }
        if(ok) cout << "1\n";
        else cout << "0\n";
    }
    return 0;
}